<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 07.01.14 10:13
 */

namespace VM\ApiBundle\Command;

use Doctrine\ORM\EntityManager;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\ApiBundle\Entity\Application;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Services\PasswordEncoder;

class GameImportTeachersCommand extends ContainerAwareCommand
{

    /**
     * @var EntityManager
     */
    protected $EntityManager;


    protected function configure()
    {
        $this
            ->setName('game:import:teachers')
            ->setDescription("Dodaje nauczycieli z pliku csv")
            ->setHelp("Dodaje nauczycieli z pliku csv składającego się z 2 kolumn (kolumny oddzielone znakiem '|'):\n1 - imię i nazwisko (oddzielone spacją)\n2 - adres email")
            ->addOption('filename', null, InputOption::VALUE_REQUIRED, 'Nazwa pliku', false)
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try
        {
            $filename = $input->getOption('filename');

            $teachers = $this->parseFile($filename);

            $PasswordEncoder = new PasswordEncoder();

            $Application = $this->getApp('GAME');
            foreach($teachers as $teacherData)
            {
                $User = new User();
                $User->setName($teacherData['name']);
                $User->setSurname($teacherData['surname']);
                $User->setUsername($teacherData['email']);
                $User->setEmail($teacherData['email']);

                $salt = md5(rand(1, 10000000));
                $User->setSalt($salt);
                $User->setEnabled(true);

                $pass = substr(md5($salt), 0, 10);

                $User->setPlainPassword(md5($pass));

                $this->getEntityManager()->persist($User);

                $ApplicationRole = $this->getApplicationRole($Application, 'ROLE_TEACHER');
                $User->addAppRole($ApplicationRole);
                $ApplicationRole->addUser($User);
                $output->writeln($teacherData['name'] . "\t". $teacherData['surname'] . "\t". $teacherData['email'] . "\t". $pass);
            }

            $this->getEntityManager()->flush();
        }
        catch(\Exception $Exception)
        {
            $output->writeln('<error>' . $Exception->getCode() . ' - ' . $Exception->getMessage() .  ' </error>');
        }
    }


    /**
     * @return EntityManager
     */
    protected function getEntityManager()
    {
        return $this->EntityManager = $this->getContainer()->get('doctrine.orm.entity_manager');
    }


    /**
     * @param $symbol
     * @return Application
     * @throws \Exception
     */
    protected function getApp($symbol)
    {
        $Application = $this->getEntityManager()->getRepository('VMApiBundle:Application')->findOneBySymbol($symbol);
        if(empty($Application))
        {
            throw new \Exception('Application is not exist');
        }
        return $Application;
    }


    /**
     * @param Application $Application
     * @param $roleSymbol
     * @return \VM\ApiBundle\Entity\ApplicationRole
     * @throws \Exception
     */
    protected function getApplicationRole(Application $Application, $roleSymbol)
    {
        $ApplicationRole = $this->getEntityManager()->getRepository('VMApiBundle:ApplicationRole')->findOneBy(array('appId' => $Application->getId(), 'symbol' => $roleSymbol));
        if(empty($ApplicationRole))
        {
            throw new \Exception('Role is not exist in application');
        }
        return $ApplicationRole;
    }


    /**
     * @param string $filename
     * @return array
     * @throws \Exception
     */
    protected function parseFile($filename)
    {
        if(!file_exists($filename))
        {
            throw new \Exception('File does not exists');
        }

        $content = file_get_contents($filename);
        $rows = explode("\n", $content);

        $teachers = array();

        foreach($rows as $row)
        {
            if($row == '')
            {
                continue;
            }
            $data = explode('|', $row);
            $names = explode(' ', $data[0]);

            $teachers[] = array(
                'name' => $names[0],
                'surname' => $names[1],
                'email' => $data[1]
            );
        }

        return $teachers;
    }
} 